#include "stdafx.h"
#include "world1.h"
#include "random.h" //for rrRandomreal in Randomlocation.
#include "math.h" //for fabs
//----TWO DIMENSIONAL -----

void Box2::_Arrange()
{ //Helper function
	Real temp;
	if (_lox > _hix)
	{
		temp = _lox;
		_lox = _hix;
		_hix = temp;
	}
	if (_loy > _hiy)  //In Real land loy IS < hiy.
	{
		temp = _loy;
		_loy = _hiy;
		_hiy = temp;
	}
}

Box2::Box2(Real px, Real py, Real qx, Real qy):
_lox(px), _loy(py),_hix(qx),_hiy(qy)
{
	_Arrange();
}

void Box2::MatchAspect(int cx, int cy)
{
	Real oldaspect, newaspect, centery;

	if (!(_hiy - _loy) || !cy)
		return;
	oldaspect = (_hix - _lox)/(_hiy - _loy);
	if (!oldaspect)
		return;
	newaspect = (Real)cx/(Real)cy;
	if (!newaspect)
		return;
	centery = (_hiy - _loy)/2.0;
	//stretch or shrink the box vertically
	_hiy = centery + (oldaspect/newaspect)*(_hiy - centery);
	_loy = centery - (oldaspect/newaspect)*(centery - _loy);
/*  If we instead wanted to stretch or shrink the box horizontally:
	_hix = centerx + (newaspect/oldaspect)*(_hix - centerx);
	_lox = centerx - (newaspect/oldaspect)*(centerx - _lox);
*/
}

Vector2 Box2::Randomlocation() const
{
	return Vector2(_lox + rrRandomreal() * (_hix - _lox),
		_loy + rrRandomreal() * (_hiy - _loy));
}


BOOL Box2::Inside(const Vector2 &testpos) const
{
	return (_lox <= testpos.x() && testpos.x() <= _hix &&
		_loy <= testpos.y() && testpos.y() <= _hiy);
}

int Box2::Outcode(const Vector2 &testpos) const
{ /* This tells you which of the nine possible positions testpos has
relative to the Box2 */
	int outcode = BOX2_INSIDE; //This is 0.

	if (_lox > testpos.x())
		outcode |= BOX2_LEFT;
	if (testpos.x() > _hix)
		outcode |= BOX2_RIGHT;
	if (_loy > testpos.y())
		outcode |= BOX2_DOWN;
	if (testpos.y() > _hiy)
		outcode |= BOX2_UP;
	return outcode;
}

Real Box2::Distance(const Vector2 &testpos) const
{ /*This gives the distance from testpos to the closest point of the
Box2.  If you are in a "side" zone your nearest distance is a point
on the side.  If you are in a "corner" zone your nearest distance is a
corner.  If you are inside, we call the distance 0.*/
	int outcode = Outcode(testpos);

	switch(outcode)
	{
		case BOX2_INSIDE:
			return 0.0;
		case BOX2_LEFT:
			return _lox - testpos.x();
		case BOX2_RIGHT:
			return testpos.x() - _hix;
		case BOX2_DOWN:
			return _loy - testpos.y();
		case BOX2_UP:
			return testpos.y() - _hiy;
		case BOX2_DOWN_LEFT:
			return (testpos - Vector2(_lox, _loy)).Magnitude();
		case BOX2_DOWN_RIGHT:
			return (testpos - Vector2(_hix, _loy)).Magnitude();
		case BOX2_UP_LEFT:
			return (testpos - Vector2(_lox, _hiy)).Magnitude();
		case BOX2_UP_RIGHT:
			return (testpos - Vector2(_hix, _hiy)).Magnitude();
	}
	return 0.0; //Unreachable default case.
}


int Box2::Wrap(Vector2 &position) const
{
 	  int outcode = BOX2_INSIDE;
	if (position.x() < _lox)
	{
		outcode |= BOX2_LEFT;
		position.Set(_hix - _lox + position.x(), position.y());
	}
	if (position.x() > _hix)
	{
		outcode |= BOX2_RIGHT;
		position.Set(_lox - _hix + position.x(), position.y());
	}
	if (position.y() < _loy)
	{
		outcode |= BOX2_DOWN;
		position.Set(position.x(), _hiy - _loy + position.y());
	}
	if (position.y() > _hiy)
	{
		outcode |= BOX2_UP;
		position.Set(position.x(), _loy - _hiy + position.y());
	}
	return outcode;
}

int Box2::Clamp(Vector2 &position) const
{
 	  int outcode = BOX2_INSIDE;
	if (position.x() < _lox)
	{
		outcode |= BOX2_LEFT;
		position.Set(_lox, position.y());
	}
	if (position.x() > _hix)
	{
		outcode |= BOX2_RIGHT;
		position.Set(_hix, position.y());
	}
	if (position.y() < _loy)
	{
		outcode |= BOX2_DOWN;
		position.Set(position.x(), _loy);
	}
	if (position.y() > _hiy)
	{
		outcode |= BOX2_UP;
		position.Set(position.x(), _hiy);
	}
	return outcode;
}
//-----------------------World--------------------

World::World(Box2 &box, Real dt, Real runspeed, BOOL wrapflag):
_box(box),
_dt(dt),
_runspeed(runspeed),
_wrapflag(wrapflag)
/* Later we'll give World an array of arrays of Critters */
{}

void World::Set_box(Box2 &box)
{ /*Later we'll let the world track its critters, and we will
	want to _box.Clamp their _position here */
	_box = box;
}

int World::Wrap(Vector2 &position)const
{
	return _box.Wrap(position);
}

int World::Clamp(Vector2 &position)const
{
	return _box.Clamp(position);
}

int World::ClampBounce(Vector2 &position, Vector2 &direction) const
{ //Clamp and bounce.
	int outcode = Clamp(position);  //outcode tells which edge you cross
	if (outcode & BOX2_LEFT) //now on left edge
		direction.Set(fabs(direction.x()), direction.y());   //move right
	if (outcode & BOX2_RIGHT) //now on right edge
		direction.Set(-fabs(direction.x()), direction.y());   //move left
	if (outcode & BOX2_UP) //now on top edge
		direction.Set(direction.x(), -fabs(direction.y()));  //move down
	if (outcode & BOX2_DOWN) //now on bottom edge
		direction.Set(direction.x(), fabs(direction.y()));  //move up
	return outcode;
}

cTimeAdjuster::cTimeAdjuster(int nCyclesToCount):
_nUpdateCount(0),
_nTargetCount(nCyclesToCount),
_rCycle_dt(0.01), //just to have a value
_start(0)
{} 

void cTimeAdjuster::reset()
{
	_start = clock();
	_nUpdateCount = 0;
}

BOOL cTimeAdjuster::update()
{
	clock_t finish;
	double duration;

	if (_nUpdateCount < _nTargetCount)
	{
		_nUpdateCount++;
		if (_nUpdateCount >= _nTargetCount)
		{
			finish = clock();
			int clockspersec = CLOCKS_PER_SEC;
			if (!clockspersec)
				return FALSE;
			duration = (double)(finish - _start) / CLOCKS_PER_SEC;
			_rCycle_dt = duration / _nTargetCount;
			return TRUE;
		}
	}
	return FALSE;
}


void World::resetTimeAdjuster()
{
	_cTimeAdjuster.reset();
}

void World::updateTimeAdjuster()
{
	if (_cTimeAdjuster.update())
		Set_dt(_cTimeAdjuster._rCycle_dt);
}

void World::setRunspeed(Real runspeed)
{
	_runspeed = runspeed;
	/* Now reset _dt based on the system dt and the new runspeed */
	Set_dt(_cTimeAdjuster._rCycle_dt);
}
